/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.launching;

import com.aptana.php.debug.core.launch.ScriptLocator;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org2.eclipse.php.internal.debug.core.Logger;
import org2.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org2.eclipse.php.internal.debug.core.interpreter.phpIni.PHPINIDebuggerUtil;
import org2.eclipse.php.internal.debug.core.interpreter.phpIni.PHPINIUtil;
import org2.eclipse.php.internal.debug.core.interpreter.preferences.PHPexeItem;
import org2.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org2.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org2.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org2.eclipse.php.internal.debug.core.preferences.PHPexes;
import org2.eclipse.php.internal.debug.core.xdebug.IDELayerFactory;
import org2.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceMgr;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandler;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.XDebugDebuggerConfiguration;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionHandler;
import org2.eclipse.php.internal.debug.core.zend.debugger.ProcessCrashDetector;

public class XDebugExeLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public static final String INTERPRETERS_PREF_ID = "org2.eclipse.php.debug.ui.preferencesphps.PHPsPreferencePage";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        PHPexeItem[] items;
        Path filePath;
        if (monitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            return;
        }
        String phpExeString = configuration.getAttribute("ATTR_LOCATION", null);
        String phpIniString = configuration.getAttribute("ATTR_INI_LOCATION", null);
        if (!this.isXDebugFunctional(phpIniString, configuration)) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            return;
        }
        String phpScriptString = ScriptLocator.getScriptFile((ILaunchConfiguration)configuration);
        if (phpScriptString == null || phpScriptString.trim().length() == 0) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            this.displayErrorMessage("The script could not be launched. \nPlease make sure that the selected script exists in the workspace. \nIn case you have selected to debug/run the current script, make sure that a PHP script is opened in the editor area.");
            return;
        }
        if (monitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            return;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource scriptRes = workspaceRoot.findMember((IPath)(filePath = new Path(phpScriptString)));
        if (scriptRes == null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            this.displayErrorMessage(PHPDebugCoreMessages.XDebug_ExeLaunchConfigurationDelegate_1);
            return;
        }
        Path phpExe = new Path(phpExeString);
        IProject project = scriptRes.getProject();
        String projectString = project.getFullPath().toString();
        ILaunchConfigurationWorkingCopy wc = null;
        wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
        wc.setAttribute("org2.eclipse.php.debug.core.PHP_Project", projectString);
        wc.setAttribute("debugTransferEncoding", PHPProjectPreferences.getTransferEncoding(project));
        wc.setAttribute("debugOutputEncoding", PHPProjectPreferences.getOutputEncoding(project));
        wc.doSave();
        if (monitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            return;
        }
        IPath projectLocation = project.getRawLocation();
        if (projectLocation == null) {
            projectLocation = project.getLocation();
        }
        IPath phpFile = scriptRes.getLocation();
        if (monitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            return;
        }
        File phpIni = phpIniString != null && new File(phpIniString).exists() ? new File(phpIniString) : PHPINIUtil.findPHPIni(phpExeString);
        File tempIni = PHPINIDebuggerUtil.prepareBeforeDebug(phpIni, phpExeString, project, "org2.eclipse.php.debug.core.xdebugDebugger");
        launch.setAttribute("PHPIniLocation", tempIni.getAbsolutePath());
        wc.doSave();
        HashMap<String, String> processAttributes = new HashMap<String, String>();
        String programName = phpExe.lastSegment();
        String extension = phpExe.getFileExtension();
        if (extension != null) {
            programName = programName.substring(0, programName.length() - (extension.length() + 1));
        }
        programName = programName.toLowerCase();
        processAttributes.put(IProcess.ATTR_PROCESS_TYPE, programName);
        processAttributes.put(IProcess.ATTR_CMDLINE, phpScriptString);
        if (monitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            return;
        }
        String[] envVarString = null;
        DBGpTarget target = null;
        if (mode.equals("debug")) {
            boolean stopAtFirstLine = PHPProjectPreferences.getStopAtFirstLine(project);
            stopAtFirstLine = configuration.getAttribute("firstLineBreakpoint", stopAtFirstLine);
            String sessionID = DBGpSessionHandler.getInstance().generateSessionId();
            String ideKey = null;
            if (DBGpProxyHandler.instance.useProxy()) {
                ideKey = DBGpProxyHandler.instance.getCurrentIdeKey();
                if (!DBGpProxyHandler.instance.registerWithProxy()) {
                    this.displayErrorMessage(String.valueOf(PHPDebugCoreMessages.XDebug_ExeLaunchConfigurationDelegate_2) + DBGpProxyHandler.instance.getErrorMsg());
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                    return;
                }
            } else {
                ideKey = DBGpSessionHandler.getInstance().getIDEKey();
            }
            target = new DBGpTarget(launch, phpFile.lastSegment(), ideKey, sessionID, stopAtFirstLine);
            target.setPathMapper(PathMapperRegistry.getByLaunchConfiguration(configuration));
            DBGpSessionHandler.getInstance().addSessionListener(target);
            envVarString = this.createDebugLaunchEnvironment(configuration, sessionID, ideKey, (IPath)phpExe);
        } else {
            envVarString = PHPLaunchUtilities.getEnvironment(configuration, new String[]{this.getLibraryPath((IPath)phpExe)});
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 30);
        subMonitor.beginTask(PHPDebugCoreMessages.XDebug_ExeLaunchConfigurationDelegate_3, 10);
        IPath workingPath = phpFile.removeLastSegments(1);
        File workingDir = workingPath.makeAbsolute().toFile();
        boolean found = false;
        int i = 0;
        while (i < envVarString.length && !found) {
            String envEntity = envVarString[i];
            String[] elements = envEntity.split("=");
            if (elements.length > 0 && elements[0].equals("XDEBUG_WORKING_DIR")) {
                found = true;
                workingPath = new Path(elements[1]);
                File temp = workingPath.makeAbsolute().toFile();
                if (temp.exists()) {
                    workingDir = temp;
                }
            }
            ++i;
        }
        File phpExeFile = new File(phpExeString);
        PHPexeItem[] pHPexeItemArray = items = PHPexes.getInstance().getAllItems();
        int n = items.length;
        int temp = 0;
        while (temp < n) {
            PHPexeItem item = pHPexeItemArray[temp];
            if (item.getExecutable().equals(phpExeFile)) {
                item.getSapiType();
                break;
            }
            ++temp;
        }
        String[] args = PHPLaunchUtilities.getProgramArguments(launch.getLaunchConfiguration());
        String[] cmdLine = PHPLaunchUtilities.getCommandLine(configuration, phpExe.toOSString(), tempIni.toString(), phpFile.toOSString(), args);
        Process phpExeProcess = DebugPlugin.exec((String[])cmdLine, (File)workingDir, (String[])envVarString);
        new Thread(new ProcessCrashDetector(phpExeProcess)).start();
        IProcess eclipseProcessWrapper = null;
        if (phpExeProcess != null) {
            subMonitor.worked(10);
            eclipseProcessWrapper = DebugPlugin.newProcess((ILaunch)launch, (Process)phpExeProcess, (String)phpExe.toOSString(), processAttributes);
            if (eclipseProcessWrapper == null) {
                phpExeProcess.destroy();
                subMonitor.done();
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                throw new CoreException((IStatus)new Status(4, "com.aptana.php.debug.epl", 0, null, null));
            }
            if (mode.equals("debug") && target != null) {
                target.setProcess(eclipseProcessWrapper);
                launch.addDebugTarget((IDebugTarget)target);
                subMonitor.subTask(PHPDebugCoreMessages.XDebug_ExeLaunchConfigurationDelegate_4);
                target.waitForInitialSession((DBGpBreakpointFacade)((Object)IDELayerFactory.getIDELayer()), XDebugPreferenceMgr.createSessionPreferences(), monitor);
            }
        } else {
            if (mode.equals("debug")) {
                DBGpSessionHandler.getInstance().removeSessionListener(target);
            }
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
        }
        subMonitor.done();
    }

    protected boolean isXDebugFunctional(String phpIniPath, ILaunchConfiguration configuration) {
        Properties ini = new Properties();
        try {
            ini.load(new FileInputStream(phpIniPath));
        }
        catch (IOException e) {
            PHPDebugEPLPlugin.logError("Error locating the XDebug debugger ini", e);
            ErrorDialog.openError(null, (String)"Debugger Error", (String)"Could not locate the XDebug ini in the specified location. \nView error log for more information.", (IStatus)new Status(4, "com.aptana.php.debug.epl", 0, "Error locating the ini", (Throwable)e));
            return false;
        }
        String xdebugIniPort = ini.getProperty("xdebug.remote_port", "null");
        XDebugDebuggerConfiguration xdebuggerConfigurations = new XDebugDebuggerConfiguration();
        if (!xdebugIniPort.equals(String.valueOf(xdebuggerConfigurations.getPort()))) {
            String message = null;
            if (!xdebugIniPort.equals("null")) {
                message = "The current configuration defined in the XDebug php.ini set the 'xdebug.remote_port' to " + xdebugIniPort + ", while the Aptana debugger client is set to listen on port " + xdebuggerConfigurations.getPort() + '.';
            } else {
                if (xdebuggerConfigurations.getPort() == 9000) {
                    return true;
                }
                message = "The current configuration defined in the XDebug php.ini does not have a setting for 'xdebug.remote_port'.\nYou will need to set it to port " + xdebuggerConfigurations.getPort() + ", or change the Aptana client port to 9000 (XDebug default) before continuing.";
            }
            message = String.valueOf(message) + "\n\nWhat would you like to do?";
            return this.showPortWarningDialog(message, configuration);
        }
        return true;
    }

    private boolean showPortWarningDialog(final String message, final ILaunchConfiguration configuration) {
        final String[] buttonsLabels = new String[]{"Change Port", "Edit ini", "Ignore"};
        final boolean[] result = new boolean[]{true};
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(null, "XDebug port verification", null, message, 4, buttonsLabels, 0){

                    protected void buttonPressed(int buttonId) {
                        try {
                            if (buttonId == 0) {
                                this.okPressed();
                                XDebugExeLaunchConfigurationDelegate.this.openDebuggerConfigurationDialog(configuration);
                            } else if (buttonId == 1) {
                                this.okPressed();
                                XDebugExeLaunchConfigurationDelegate.this.openInterpretersPage(configuration);
                            } else {
                                this.cancelPressed();
                            }
                        }
                        catch (CoreException e) {
                            PHPDebugEPLPlugin.logError("Error while showing the xdebug warning dialog", e);
                        }
                    }
                };
                if (dialog.open() == 0) {
                    result[0] = false;
                }
            }
        });
        return result[0];
    }

    private void openInterpretersPage(ILaunchConfiguration configuration) throws CoreException {
        String phpIniPath;
        String phpExeString;
        PHPexes exes = PHPexes.getInstance();
        PHPexeItem pexeItem = exes.getItemForFile(phpExeString = configuration.getAttribute("ATTR_LOCATION", null), phpIniPath = configuration.getAttribute("ATTR_INI_LOCATION", null));
        if (pexeItem == null) {
            PHPDebugEPLPlugin.logError("Error editing the ini for " + phpExeString + " ---> " + phpIniPath + ". \nPHPexeItem is null.");
            return;
        }
        PreferenceDialog pref = PreferencesUtil.createPreferenceDialogOn(null, (String)INTERPRETERS_PREF_ID, null, (Object)pexeItem);
        if (pref != null) {
            pref.open();
        }
    }

    private void openDebuggerConfigurationDialog(ILaunchConfiguration configuration) {
        XDebugDebuggerConfiguration xdebuggerConfigurations = new XDebugDebuggerConfiguration();
        xdebuggerConfigurations.openConfigurationDialog(null);
    }

    public String[] createDebugLaunchEnvironment(ILaunchConfiguration configuration, String sessionID, String ideKey, IPath phpExe) throws CoreException {
        String configEnv = "XDEBUG_CONFIG=remote_enable=1 idekey=" + ideKey;
        String extraDBGpEnv = "DBGP_IDEKEY=" + ideKey;
        String sessEnv = "DBGP_COOKIE=" + sessionID;
        Logger.debugMSG("env=" + configEnv + ", Cookie=" + sessEnv);
        String[] envVarString = PHPLaunchUtilities.getEnvironment(configuration, new String[]{configEnv, extraDBGpEnv, sessEnv, this.getLibraryPath(phpExe)});
        return envVarString;
    }

    public String[] createCommandLine(ILaunchConfiguration configuration, String phpConfigDir, String exeName, String scriptName) throws CoreException {
        String phpIniLocation = configuration.getAttribute("PHPIniLocation", "");
        if (!"".equals(phpIniLocation)) {
            phpConfigDir = new File(phpIniLocation).getParent();
        }
        return PHPLaunchUtilities.getCommandLine(configuration, exeName, phpConfigDir, scriptName, null);
    }

    private String getLibraryPath(IPath exePath) {
        StringBuffer buf = new StringBuffer();
        if ("macosx".equals(Platform.getOS())) {
            buf.append("DYLD_LIBRARY_PATH");
        } else {
            buf.append("LD_LIBRARY_PATH");
        }
        buf.append('=');
        exePath = exePath.removeLastSegments(1);
        buf.append(exePath.toOSString());
        return buf.toString();
    }

    protected void displayErrorMessage(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug Error", (String)message);
            }
        });
    }
}

